"""
This python execution file runs the DogFish experiment,
where we apply our experimental pipeline for the DogFish dataset
for varying values of the regularization parameter.
"""


import numpy as np

from experiments.experimental_pipeline import ExperimentalPipeline, ForceRefreshLevel
import os

DATASET = "DogFish"
REGULARIZATIONS = [1E-5, 1E-4, 1E-3, 1E-2, 1E-1, 1.0]
REG_NAMES = ["1E-5", "1E-4", "1E-3", "1E-2", "1E-1", "1"]

if __name__ == "__main__":
    for reg_name, regularization in zip(REG_NAMES, REGULARIZATIONS):
        print("\n" + "=" * 80)
        print(f"Starting experiment for {DATASET=}, {regularization=}")
        print("=" * 80)

        try:
            # Initialize and run the experimental pipeline
            experimental_pipeline = ExperimentalPipeline(
                dataset_name=DATASET,
                verbosity=2,
                reg_type="L2",
                regularization=regularization,
                experiment_name=f"{DATASET}_{reg_name}",
                force_refresh=ForceRefreshLevel.MODEL_WEIGHTS
            )
            experimental_pipeline.run()
        except KeyboardInterrupt:
            print("\nExperiment interrupted. Exiting.")
            raise
        except Exception as e:
            print(f"\nAn error occurred while running the experiment for {DATASET}: {e}")
            continue  # Proceed to the next dataset
